/*
*   \file
*   \remarks Top level exposed APIs (DRM Manager) Prototypes
*   \author Pavel Haber
*
*   WMDRM Service Package, Type Definitions, Top level exposed APIs (DRM Manager)
*
*   Copyright (C) 2007 by Discretix Technologies Ltd.
*           All rights reserved.
*
*/

#ifndef DRMMANAGER_TST_API_H
#define DRMMANAGER_TST_API_H

DRM_RESULT DRMM_PreTestCase(long lTCID, char *strTCName);
DRM_RESULT DRMM_PostTestCase(long lTCID, char *strTCName);

DRM_RESULT TestManagerReinitialize(long argc, char **argv);
DRM_RESULT TestManagerInitialize(long argc, char **argv);
DRM_RESULT TestManagerChangeTime(long argc, char **argv);
DRM_RESULT TestManagerSetRevocationInfo(long argc, char **argv);
DRM_RESULT TestManagerSetRevocation(long argc, char **argv);
DRM_RESULT TestManagerGetRevocationInfo(long argc, char **argv);
DRM_RESULT TestManagerGetRevocationList(long argc, char **argv);
DRM_RESULT TestUpdateRevocationVersionsCache(long argc, char **argv);
DRM_RESULT TestManagerStoreRevocationLists(long argc, char **argv);
DRM_RESULT TestManagerGetLicenseRevInfoVersion(long argc, char **argv);
DRM_RESULT TestManagerSetRights(long argc, char **argv);
DRM_RESULT TestManagerSetV2Header(long argc, char **argv);
DRM_RESULT TestManagerGetLicenseData(long argc, char **argv);
DRM_RESULT TestManagerPrepareOPLCallback(long argc, char **argv);
DRM_RESULT TestManagerBind(long argc, char **argv);
DRM_RESULT TestManagerDecrypt(long argc, char **argv);
DRM_RESULT TestManagerCreateEncryptContext(long argc, char **argv);
DRM_RESULT TestManagerEncrypt(long argc, char **argv);
DRM_RESULT TestManagerCommit(long argc, char **argv);
DRM_RESULT TestManagerGenerateChallenge(long argc, char **argv);
DRM_RESULT TestManagerInitResponse(long argc, char **argv);
DRM_RESULT TestManagerAddLicenseToResponse(long argc, char **argv);
DRM_RESULT TestManagerGenerateResponse(long argc, char **argv);
DRM_RESULT TestManagerProcessResponse(long argc, char **argv);
DRM_RESULT TestManagerInitializeForNewStore(long argc, char **argv);
DRM_RESULT TestManagerSetMachineClock(long argc, char **argv);
DRM_RESULT TestManagerGetDeviceProperty(long argc, char **argv);
DRM_RESULT TestManagerSetGetClockState(long argc, char **argv);
DRM_RESULT TestManagerCleanLicenseStore(long argc, char **argv);
DRM_RESULT TestEnumLicense(long argc, char **argv);
DRM_RESULT TestManagerGetSourceID(long argc, char **argv);
DRM_RESULT TestManagerGetLicenseState(long argc, char **argv);
DRM_RESULT TestManagerMakeDeviceLicenseRevocationBlob(long argc, char **argv);
DRM_RESULT TestManagerProcessDeviceLicenseRevocation(long argc, char **argv);

#endif

